unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TMainForm = class(TForm)
    Memo1: TMemo;
    Memo2: TMemo;
    Panel1: TPanel;
    btnKONIEC: TBitBtn;
    btnPODZIEL: TBitBtn;
    btnPOSKLADAJ: TBitBtn;
    OpenDialog: TOpenDialog;
    LabeledEdit1: TLabeledEdit;
    procedure FormShow(Sender: TObject);
    procedure btnPOSKLADAJClick(Sender: TObject);
    procedure btnPODZIELClick(Sender: TObject);
    procedure btnKONIECClick(Sender: TObject);

  private
	 procedure Podziel_plik(fn : String);
	 procedure Poskladaj_plik();    
  public

  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.btnKONIECClick(Sender: TObject);
begin
	Close();
end;

procedure TMainForm.btnPODZIELClick(Sender: TObject);
var
	fn : String;

begin
	if OpenDialog.Execute() then
   begin
		fn := OpenDialog.FileName;
	   Podziel_plik(fn);
	   Close();
   end;
end;

procedure TMainForm.btnPOSKLADAJClick(Sender: TObject);
begin
   Poskladaj_plik();
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
	Memo1.Clear();
	Memo2.Clear();
end;

procedure TMainForm.Podziel_plik(fn : String);
var
	finp        : String;
   fout        : String;
	str_inp     : TFileStream;
	str_out     : TFileStream;
   lp          : Integer;
   iSize       : Integer;
   iPorcja     : Integer;
   bWykonuj    : Boolean;
   cPORCJA     : Integer;

begin
   finp      := '';
	fout      := '';
   str_inp   := Nil;
   str_out   := Nil;
   lp        := 0;
   iSize     := 0;
   iPorcja   := 0;
   bWykonuj  := false;
   cPORCJA   := 0;

   // ustalam rozmiar porcji - pojedynczego pliku
   cPORCJA := StrToIntDef(LabeledEdit1.Text, 10000); // := 25000000 ~25MB

	iSize   := 0;
   iPorcja := 0;
	lp      := 1;

	// finp := ExtractfilePath(Application.ExeName) + 'jb9_windows.zip';
   finp := fn;

   if not FileExists(finp) then
   begin
      ShowMessage('Brak pliku: ' + finp);
      exit;
   end;

   try
   	str_inp  := TFileStream.Create(finp, fmOpenRead);
      iSize    := str_inp.Size;

		lp       := 0;
		bWykonuj := true;

      while bWykonuj do
      begin
         Inc(lp);

         iSize := iSize - iPorcja;

         if iSize > cPORCJA then
         begin
         	iPorcja := cPORCJA;
         end
         else begin
				iPorcja := iSize;
         end;

         if iPorcja <= 0 then
         begin
         	break;
         end;

         fout := ExtractFilePath(Application.ExeName) + 'Frag' +
                 IntToStr(lp) + '.txt';

         Memo1.Lines.Add(fout);

      	str_out := TFileStream.Create(fout, fmCreate);

         str_out.CopyFrom(str_inp, iPorcja);

         str_inp.Seek(iPorcja * lp, soFromBeginning);
      end;
	finally
   	FreeAndNil(str_inp);
   	FreeAndNil(str_out);

      ShowMessage('Podzia pliku zakoczony!');
		Memo1.Lines.SaveToFile('lista_plikow.txt');
   end;
end;

procedure TMainForm.Poskladaj_plik();
var
	finp    : String;
   fout    : String;
	str_inp : TFileStream;
	str_out : TFileStream;
   lp      : Integer;

begin
	finp    := '';
   fout    := '';
	str_inp := Nil;
	str_out := Nil;
   lp      := 0;

   Memo1.Clear();
   Memo2.Clear();
   Memo1.Lines.LoadFromFile('lista_plikow.txt');

	lp      := 1;

   fout    := ExtractFilePath(Application.ExeName) + 'TEST.BAC';
   ShowMessage('Plik zostanie poczony do pliku o nazwie TEST.BAC');

   str_out := TFileStream.Create(fout, fmCreate);

	for lp := 0 to Memo1.Lines.Count-1 do
   begin
      finp := ExtractFilePath(Application.ExeName) + 'Frag' +
              IntToStr(lp+1) + '.txt';

		Memo2.Lines.Add(finp);

   	str_inp := TFileStream.Create(finp, fmOpenRead);
      str_out.CopyFrom(str_inp, str_inp.Size);
      FreeAndNil(str_inp);
   end;

   FreeAndNil(str_out);

   ShowMessage('czenie pliku zakoczone!');
end;

end.
